/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.toy;

import edu.princeton.swing.PSwingUtilities;
import edu.princeton.toy.TImageManager;
import edu.princeton.toy.lang.TVirtualMachine;
import edu.princeton.toy.lang.TWord;
import edu.princeton.toy.lang.TWordBuffer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TSimMachinePane
extends JLayeredPane {
    private static final String CLASS_STRING = TSimMachinePane.class.toString();
    public static final String RESCALE_COMMAND = CLASS_STRING + "#rescaleCommand";
    public static final String UPDATE_COMMAND = CLASS_STRING + "#updateCommand";
    public static final int PC_BIT_COUNT = 8;
    public static final int ADDR_BIT_COUNT = 8;
    public static final int INSTR_BIT_COUNT = 16;
    public static final int DATA_BIT_COUNT = 16;
    public static final Color BLUE_AREA_COLOR = new Color(80, 100, 120);
    public static final Border BLUE_AREA_BORDER = new LineBorder(Color.black, 1);
    public static final Border PLACEHOLDER_BORDER = new EtchedBorder(1);
    public static final int MIN_SCALE = 1;
    public static final int MAX_SCALE = TImageManager.MAX_SCALE[0];
    public static final int PREFERRED_SCALE = 8;
    private static final Insets ZERO_INSETS = new Insets(0, 0, 0, 0);
    private static final Integer[] INTEGERS = new Integer[MAX_SCALE + 1];
    private static final int UNSCALED_WIDTH = 80;
    private static final int UNSCALED_HEIGHT = 47;
    private int newScale;
    private int scale;
    private Listener listener;
    private Runner runner;
    private TVirtualMachine virtualMachine;
    private List changeListeners;
    private JPanel bluePanel;
    private JPanel placeholderPanel;
    private JLabel placeholderLabel;
    private Action loadAction;
    private Action lookAction;
    private Action stepAction;
    private Action runAction;
    private Action enterAction;
    private Action interruptAction;
    private Action resetAction;
    private JButton loadButton;
    private JButton lookButton;
    private JButton stepButton;
    private JButton runButton;
    private JButton enterButton;
    private JButton interruptButton;
    private JButton resetButton;
    private JLabel inwaitLabel;
    private JLabel inwaitLight;
    private JLabel readyLabel;
    private JLabel readyLight;
    private JLabel pcLabel;
    private JLabel[] pcLights;
    private JLabel addrLabel;
    private JToggleButton[] addrSwitches;
    private ButtonModel[] addrSwitchModels;
    private JLabel instrLabel;
    private JLabel[] instrLights;
    private JLabel dataLabel;
    private JToggleButton[] dataSwitches;
    private ButtonModel[] dataSwitchModels;
    private JLabel stdoutLabel;
    private JLabel[] stdoutDigits;
    private TWordBuffer stdout;
    private Icon switchOffIcon;
    private Icon switchOnIcon;
    private Icon blankDigitIcon;
    private Icon[] digitIcons;

    public TSimMachinePane(TVirtualMachine virtualMachine, Action loadAction, Action lookAction, Action stepAction, Action runAction, Action enterAction, Action interruptAction, Action resetAction) {
        int ctr;
        this.setLayout(null);
        this.setDoubleBuffered(true);
        if (virtualMachine == null) {
            throw new NullPointerException();
        }
        this.virtualMachine = virtualMachine;
        this.runner = new Runner();
        this.listener = new Listener();
        virtualMachine.addChangeListener(this.listener);
        this.changeListeners = new ArrayList();
        if (loadAction == null || lookAction == null || stepAction == null || runAction == null || enterAction == null || interruptAction == null || resetAction == null) {
            throw new NullPointerException();
        }
        this.loadAction = loadAction;
        this.lookAction = lookAction;
        this.stepAction = stepAction;
        this.runAction = runAction;
        this.enterAction = enterAction;
        this.interruptAction = interruptAction;
        this.resetAction = resetAction;
        loadAction.addPropertyChangeListener(this.listener);
        lookAction.addPropertyChangeListener(this.listener);
        stepAction.addPropertyChangeListener(this.listener);
        runAction.addPropertyChangeListener(this.listener);
        enterAction.addPropertyChangeListener(this.listener);
        interruptAction.addPropertyChangeListener(this.listener);
        resetAction.addPropertyChangeListener(this.listener);
        this.bluePanel = new JPanel(null, false);
        this.bluePanel.setBackground(BLUE_AREA_COLOR);
        this.bluePanel.setBorder(BLUE_AREA_BORDER);
        this.loadButton = new JButton();
        this.bluePanel.add(this.loadButton);
        this.loadButton.setBorderPainted(false);
        this.loadButton.setContentAreaFilled(false);
        this.loadButton.setFocusPainted(false);
        this.loadButton.setMargin(ZERO_INSETS);
        this.loadButton.addActionListener(loadAction);
        this.loadButton.setEnabled(loadAction.isEnabled());
        this.lookButton = new JButton();
        this.bluePanel.add(this.lookButton);
        this.lookButton.setBorderPainted(false);
        this.lookButton.setContentAreaFilled(false);
        this.lookButton.setFocusPainted(false);
        this.lookButton.setMargin(ZERO_INSETS);
        this.lookButton.addActionListener(lookAction);
        this.lookButton.setEnabled(lookAction.isEnabled());
        this.stepButton = new JButton();
        this.bluePanel.add(this.stepButton);
        this.stepButton.setBorderPainted(false);
        this.stepButton.setContentAreaFilled(false);
        this.stepButton.setFocusPainted(false);
        this.stepButton.setMargin(ZERO_INSETS);
        this.stepButton.addActionListener(stepAction);
        this.stepButton.setEnabled(stepAction.isEnabled());
        this.runButton = new JButton();
        this.bluePanel.add(this.runButton);
        this.runButton.setBorderPainted(false);
        this.runButton.setContentAreaFilled(false);
        this.runButton.setFocusPainted(false);
        this.runButton.setMargin(ZERO_INSETS);
        this.runButton.addActionListener(runAction);
        this.runButton.setEnabled(runAction.isEnabled());
        this.enterButton = new JButton();
        this.bluePanel.add(this.enterButton);
        this.enterButton.setBorderPainted(false);
        this.enterButton.setContentAreaFilled(false);
        this.enterButton.setFocusPainted(false);
        this.enterButton.setMargin(ZERO_INSETS);
        this.enterButton.addActionListener(enterAction);
        this.enterButton.setEnabled(enterAction.isEnabled());
        this.interruptButton = new JButton();
        this.bluePanel.add(this.interruptButton);
        this.interruptButton.setBorderPainted(false);
        this.interruptButton.setContentAreaFilled(false);
        this.interruptButton.setFocusPainted(false);
        this.interruptButton.setMargin(ZERO_INSETS);
        this.interruptButton.addActionListener(interruptAction);
        this.interruptButton.setEnabled(interruptAction.isEnabled());
        this.resetButton = new JButton();
        this.bluePanel.add(this.resetButton);
        this.resetButton.setBorderPainted(false);
        this.resetButton.setContentAreaFilled(false);
        this.resetButton.setFocusPainted(false);
        this.resetButton.setMargin(ZERO_INSETS);
        this.resetButton.addActionListener(resetAction);
        this.resetButton.setEnabled(resetAction.isEnabled());
        this.inwaitLabel = new JLabel();
        this.bluePanel.add(this.inwaitLabel);
        this.inwaitLight = new JLabel();
        this.bluePanel.add(this.inwaitLight);
        this.readyLabel = new JLabel();
        this.bluePanel.add(this.readyLabel);
        this.readyLight = new JLabel();
        this.bluePanel.add(this.readyLight);
        this.pcLabel = new JLabel();
        this.bluePanel.add(this.pcLabel);
        this.pcLights = new JLabel[8];
        for (ctr = 0; ctr < 8; ++ctr) {
            this.pcLights[ctr] = new JLabel();
            this.bluePanel.add(this.pcLights[ctr]);
        }
        this.addrLabel = new JLabel();
        this.bluePanel.add(this.addrLabel);
        this.addrSwitches = new JToggleButton[8];
        this.addrSwitchModels = new ButtonModel[8];
        for (ctr = 0; ctr < 8; ++ctr) {
            this.addrSwitches[ctr] = new JToggleButton();
            this.bluePanel.add(this.addrSwitches[ctr]);
            this.addrSwitches[ctr].addActionListener(this.listener);
            this.addrSwitches[ctr].setBorderPainted(false);
            this.addrSwitches[ctr].setContentAreaFilled(false);
            this.addrSwitches[ctr].setFocusPainted(false);
            this.addrSwitches[ctr].setMargin(ZERO_INSETS);
            this.addrSwitchModels[ctr] = this.addrSwitches[ctr].getModel();
        }
        this.instrLabel = new JLabel();
        this.bluePanel.add(this.instrLabel);
        this.instrLights = new JLabel[16];
        for (ctr = 0; ctr < 16; ++ctr) {
            this.instrLights[ctr] = new JLabel();
            this.bluePanel.add(this.instrLights[ctr]);
        }
        this.dataLabel = new JLabel();
        this.bluePanel.add(this.dataLabel);
        this.dataSwitches = new JToggleButton[16];
        this.dataSwitchModels = new ButtonModel[16];
        for (ctr = 0; ctr < 16; ++ctr) {
            this.dataSwitches[ctr] = new JToggleButton();
            this.bluePanel.add(this.dataSwitches[ctr]);
            this.dataSwitches[ctr].addActionListener(this.listener);
            this.dataSwitches[ctr].setBorderPainted(false);
            this.dataSwitches[ctr].setContentAreaFilled(false);
            this.dataSwitches[ctr].setFocusPainted(false);
            this.dataSwitches[ctr].setMargin(ZERO_INSETS);
            this.dataSwitchModels[ctr] = this.dataSwitches[ctr].getModel();
        }
        this.stdoutLabel = new JLabel();
        this.bluePanel.add(this.stdoutLabel);
        this.stdoutDigits = new JLabel[4];
        this.stdoutDigits[3] = new JLabel();
        this.bluePanel.add(this.stdoutDigits[3]);
        this.stdoutDigits[2] = new JLabel();
        this.bluePanel.add(this.stdoutDigits[2]);
        this.stdoutDigits[1] = new JLabel();
        this.bluePanel.add(this.stdoutDigits[1]);
        this.stdoutDigits[0] = new JLabel();
        this.bluePanel.add(this.stdoutDigits[0]);
        this.add((Component)this.bluePanel, new Integer(0));
        this.placeholderPanel = new JPanel();
        this.placeholderPanel.setBorder(PLACEHOLDER_BORDER);
        this.placeholderPanel.setVisible(false);
        this.add((Component)this.placeholderPanel, new Integer(1));
        this.placeholderLabel = new JLabel("Visual X-TOY is curently resizing the graphics needed for sim mode...", 0);
        this.placeholderLabel.setOpaque(false);
        this.placeholderLabel.setVerticalTextPosition(0);
        this.placeholderLabel.setVisible(false);
        this.placeholderLabel.setCursor(Cursor.getPredefinedCursor(3));
        this.add((Component)this.placeholderLabel, new Integer(2));
        this.stdout = new TWordBuffer();
        this.digitIcons = new Icon[TImageManager.MACHINE_SCALED_DIGITS.length];
        this.scale = -1;
        this.doCommand(RESCALE_COMMAND, INTEGERS[TImageManager.ORIGINAL_IMAGE_SCALES[0]]);
        this.setMinimumSize(new Dimension(80, 47));
        this.setPreferredSize(new Dimension(640, 376));
        this.enableEvents(1L);
    }

    public synchronized void addChangeListener(ChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.changeListeners.add(listener);
    }

    public synchronized void removeChangeListener(ChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.changeListeners.remove(listener);
    }

    public void setVirtualMachine(TVirtualMachine virtualMachine) {
        if (virtualMachine == null) {
            throw new NullPointerException();
        }
        if (this.virtualMachine == virtualMachine) {
            return;
        }
        this.virtualMachine.removeChangeListener(this.listener);
        virtualMachine.addChangeListener(this.listener);
        this.virtualMachine = virtualMachine;
        this.doCommand(UPDATE_COMMAND, null);
    }

    public TVirtualMachine getVirtualMachine() {
        return this.virtualMachine;
    }

    public TWord getAddr() {
        int value = 0;
        for (int ctr = 0; ctr < 8; ++ctr) {
            if (!this.addrSwitchModels[ctr].isSelected()) continue;
            value |= 1 << ctr;
        }
        return TWord.getWord((short)value);
    }

    public TWord getData() {
        int value = 0;
        for (int ctr = 0; ctr < 16; ++ctr) {
            if (!this.dataSwitchModels[ctr].isSelected()) continue;
            value |= 1 << ctr;
        }
        return TWord.getWord((short)value);
    }

    protected void fireStateChanged() {
        if (!this.changeListeners.isEmpty()) {
            ChangeEvent e = new ChangeEvent(this);
            Object[] array = this.changeListeners.toArray();
            for (int ctr = 0; ctr < array.length; ++ctr) {
                ((ChangeListener)array[ctr]).stateChanged(e);
            }
        }
    }

    public synchronized boolean doCommand(String command, Object extraInfo) {
        if (command == RESCALE_COMMAND) {
            int ctr;
            Icon switchOnIcon;
            Icon switchOffIcon;
            int scale = (Integer)extraInfo;
            if (scale < 1 || scale > MAX_SCALE) {
                throw new IllegalArgumentException();
            }
            if (scale == this.scale) {
                this.doCommand(UPDATE_COMMAND, null);
                return false;
            }
            Icon lightOffIcon = TImageManager.getIcon((byte)0, scale, (short)23);
            Icon lightOnIcon = TImageManager.getIcon((byte)0, scale, (short)24);
            this.switchOffIcon = switchOffIcon = TImageManager.getIcon((byte)0, scale, (short)21);
            this.switchOnIcon = switchOnIcon = TImageManager.getIcon((byte)0, scale, (short)22);
            this.blankDigitIcon = TImageManager.getIcon((byte)0, scale, (short)25);
            for (ctr = 0; ctr < TImageManager.MACHINE_SCALED_DIGITS.length; ++ctr) {
                this.digitIcons[ctr] = TImageManager.getIcon((byte)0, scale, TImageManager.MACHINE_SCALED_DIGITS[ctr]);
            }
            this.loadButton.setDisabledIcon(TImageManager.getIcon((byte)0, scale, (short)4));
            this.loadButton.setPressedIcon(TImageManager.getIcon((byte)0, scale, (short)4));
            this.loadButton.setIcon(TImageManager.getIcon((byte)0, scale, (short)5));
            this.loadButton.setBounds(2 * scale, 2 * scale, 8 * scale, 3 * scale);
            this.lookButton.setDisabledIcon(TImageManager.getIcon((byte)0, scale, (short)6));
            this.lookButton.setPressedIcon(TImageManager.getIcon((byte)0, scale, (short)6));
            this.lookButton.setIcon(TImageManager.getIcon((byte)0, scale, (short)7));
            this.lookButton.setBounds(12 * scale, 2 * scale, 8 * scale, 3 * scale);
            this.stepButton.setDisabledIcon(TImageManager.getIcon((byte)0, scale, (short)12));
            this.stepButton.setPressedIcon(TImageManager.getIcon((byte)0, scale, (short)12));
            this.stepButton.setIcon(TImageManager.getIcon((byte)0, scale, (short)13));
            this.stepButton.setBounds(22 * scale, 2 * scale, 8 * scale, 3 * scale);
            this.runButton.setDisabledIcon(TImageManager.getIcon((byte)0, scale, (short)10));
            this.runButton.setPressedIcon(TImageManager.getIcon((byte)0, scale, (short)10));
            this.runButton.setIcon(TImageManager.getIcon((byte)0, scale, (short)11));
            this.runButton.setBounds(32 * scale, 2 * scale, 8 * scale, 3 * scale);
            this.enterButton.setDisabledIcon(TImageManager.getIcon((byte)0, scale, (short)0));
            this.enterButton.setPressedIcon(TImageManager.getIcon((byte)0, scale, (short)0));
            this.enterButton.setIcon(TImageManager.getIcon((byte)0, scale, (short)1));
            this.enterButton.setBounds(42 * scale, 2 * scale, 8 * scale, 3 * scale);
            this.interruptButton.setDisabledIcon(TImageManager.getIcon((byte)0, scale, (short)2));
            this.interruptButton.setPressedIcon(TImageManager.getIcon((byte)0, scale, (short)2));
            this.interruptButton.setIcon(TImageManager.getIcon((byte)0, scale, (short)3));
            this.interruptButton.setBounds(52 * scale, 2 * scale, 8 * scale, 3 * scale);
            this.resetButton.setDisabledIcon(TImageManager.getIcon((byte)0, scale, (short)8));
            this.resetButton.setPressedIcon(TImageManager.getIcon((byte)0, scale, (short)8));
            this.resetButton.setIcon(TImageManager.getIcon((byte)0, scale, (short)9));
            this.resetButton.setBounds(70 * scale, 2 * scale, 8 * scale, 3 * scale);
            this.inwaitLabel.setIcon(TImageManager.getIcon((byte)0, scale, (short)17));
            this.inwaitLabel.setBounds(47 * scale, 7 * scale, 10 * scale, 2 * scale);
            this.inwaitLight.setDisabledIcon(lightOffIcon);
            this.inwaitLight.setIcon(lightOnIcon);
            this.inwaitLight.setBounds(42 * scale, 6 * scale, 4 * scale, 4 * scale);
            this.readyLabel.setIcon(TImageManager.getIcon((byte)0, scale, (short)19));
            this.readyLabel.setBounds(67 * scale, 7 * scale, 9 * scale, 2 * scale);
            this.readyLight.setDisabledIcon(lightOffIcon);
            this.readyLight.setIcon(lightOnIcon);
            this.readyLight.setBounds(62 * scale, 6 * scale, 4 * scale, 4 * scale);
            this.pcLabel.setIcon(TImageManager.getIcon((byte)0, scale, (short)18));
            this.pcLabel.setBounds(2 * scale, 11 * scale, 3 * scale, 2 * scale);
            for (ctr = 0; ctr < 8; ++ctr) {
                this.pcLights[ctr].setDisabledIcon(lightOffIcon);
                this.pcLights[ctr].setIcon(lightOnIcon);
                this.pcLights[ctr].setBounds((2 + 4 * ((8 - ctr - 1) / 4 + 8 - ctr - 1)) * scale, 13 * scale, 4 * scale, 4 * scale);
            }
            this.addrLabel.setIcon(TImageManager.getIcon((byte)0, scale, (short)14));
            this.addrLabel.setBounds(2 * scale, 17 * scale, 7 * scale, 2 * scale);
            for (ctr = 0; ctr < 8; ++ctr) {
                this.addrSwitches[ctr].setIcon(switchOffIcon);
                this.addrSwitches[ctr].setSelectedIcon(switchOnIcon);
                this.addrSwitches[ctr].setPressedIcon(this.addrSwitchModels[ctr].isSelected() ? switchOffIcon : switchOnIcon);
                this.addrSwitches[ctr].setBounds((2 + 4 * ((8 - ctr - 1) / 4 + 8 - ctr - 1)) * scale, 19 * scale, 4 * scale, 8 * scale);
            }
            this.instrLabel.setIcon(TImageManager.getIcon((byte)0, scale, (short)16));
            this.instrLabel.setBounds(2 * scale, 29 * scale, 8 * scale, 2 * scale);
            for (ctr = 0; ctr < 16; ++ctr) {
                this.instrLights[ctr].setDisabledIcon(lightOffIcon);
                this.instrLights[ctr].setIcon(lightOnIcon);
                this.instrLights[ctr].setBounds((2 + 4 * ((16 - ctr - 1) / 4 + 16 - ctr - 1)) * scale, 31 * scale, 4 * scale, 4 * scale);
            }
            this.dataLabel.setIcon(TImageManager.getIcon((byte)0, scale, (short)15));
            this.dataLabel.setBounds(2 * scale, 35 * scale, 7 * scale, 2 * scale);
            for (ctr = 0; ctr < 16; ++ctr) {
                this.dataSwitches[ctr].setIcon(switchOffIcon);
                this.dataSwitches[ctr].setSelectedIcon(switchOnIcon);
                this.dataSwitches[ctr].setPressedIcon(this.dataSwitchModels[ctr].isSelected() ? switchOffIcon : switchOnIcon);
                this.dataSwitches[ctr].setBounds((2 + 4 * ((16 - ctr - 1) / 4 + 16 - ctr - 1)) * scale, 37 * scale, 4 * scale, 8 * scale);
            }
            this.stdoutLabel.setIcon(TImageManager.getIcon((byte)0, scale, (short)20));
            this.stdoutLabel.setBounds(42 * scale, 11 * scale, 10 * scale, 2 * scale);
            this.stdoutDigits[3].setBounds(42 * scale, 14 * scale, 8 * scale, 12 * scale);
            this.stdoutDigits[2].setBounds(51 * scale, 14 * scale, 8 * scale, 12 * scale);
            this.stdoutDigits[1].setBounds(60 * scale, 14 * scale, 8 * scale, 12 * scale);
            this.stdoutDigits[0].setBounds(69 * scale, 14 * scale, 8 * scale, 12 * scale);
            this.scale = scale;
            this.doCommand(UPDATE_COMMAND, null);
            return true;
        }
        if (command == UPDATE_COMMAND) {
            this.inwaitLight.setEnabled(this.virtualMachine.needsInput());
            this.readyLight.setEnabled(!this.virtualMachine.isRunning() && !this.virtualMachine.needsInput());
            short pcValue = this.virtualMachine.getProgramCtr().getValue();
            for (int ctr = 0; ctr < 8; ++ctr) {
                this.pcLights[ctr].setEnabled((pcValue >> ctr & 1) != 0);
            }
            short instrValue = this.virtualMachine.getMem(pcValue & 0xFF).getValue();
            for (int ctr = 0; ctr < 16; ++ctr) {
                this.instrLights[ctr].setEnabled((instrValue >> ctr & 1) != 0);
            }
            this.virtualMachine.getStdout(this.stdout);
            int size = this.stdout.getSize();
            if (size > 0) {
                TWord lastWord = this.stdout.getWord(size - 1);
                this.stdoutDigits[3].setIcon(this.digitIcons[lastWord.getOp()]);
                this.stdoutDigits[2].setIcon(this.digitIcons[lastWord.getD()]);
                this.stdoutDigits[1].setIcon(this.digitIcons[lastWord.getS()]);
                this.stdoutDigits[0].setIcon(this.digitIcons[lastWord.getT()]);
            } else {
                this.stdoutDigits[3].setIcon(this.blankDigitIcon);
                this.stdoutDigits[2].setIcon(this.blankDigitIcon);
                this.stdoutDigits[1].setIcon(this.blankDigitIcon);
                this.stdoutDigits[0].setIcon(this.blankDigitIcon);
            }
            this.repaint();
            return true;
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processComponentEvent(ComponentEvent e) {
        if (e.getID() == 101) {
            int height;
            int width = this.getWidth();
            int scale = Math.min(width / 80, (height = this.getHeight()) / 47);
            if (scale < 1) {
                scale = 1;
            }
            if (scale > MAX_SCALE) {
                scale = MAX_SCALE;
            }
            this.bluePanel.setBounds(width / 2 - 80 * scale / 2, height / 2 - 47 * scale / 2, 80 * scale, 47 * scale);
            TSimMachinePane tSimMachinePane = this;
            synchronized (tSimMachinePane) {
                this.newScale = scale;
                if (!this.runner.isRunning) {
                    if (!TImageManager.isPrepared((byte)0, scale)) {
                        this.bluePanel.setVisible(false);
                        this.placeholderPanel.setBounds(width / 2 - 80 * scale / 2, height / 2 - 47 * scale / 2, 80 * scale, 47 * scale);
                        this.placeholderPanel.setVisible(true);
                        this.placeholderLabel.setBounds(0, 0, width, height);
                        this.placeholderLabel.setVisible(true);
                        PSwingUtilities.paintWindowImmediately(this);
                        this.runner.start();
                    } else {
                        this.doCommand(RESCALE_COMMAND, INTEGERS[scale]);
                    }
                } else {
                    this.placeholderPanel.setBounds(width / 2 - 80 * scale / 2, height / 2 - 47 * scale / 2, 80 * scale, 47 * scale);
                    this.placeholderLabel.setBounds(0, 0, width, height);
                    PSwingUtilities.paintWindowImmediately(this);
                }
            }
        }
        super.processComponentEvent(e);
    }

    static {
        for (int ctr = 0; ctr <= MAX_SCALE; ++ctr) {
            TSimMachinePane.INTEGERS[ctr] = new Integer(ctr);
        }
    }

    protected class Runner
    implements Runnable {
        protected boolean isRunning = false;
        private Thread thread;

        protected Runner() {
        }

        public void start() {
            this.isRunning = true;
            this.thread = new Thread(this);
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                int scale;
                TSimMachinePane tSimMachinePane = TSimMachinePane.this;
                synchronized (tSimMachinePane) {
                    scale = TSimMachinePane.this.newScale;
                    if (TImageManager.isPrepared((byte)0, scale)) {
                        TSimMachinePane.this.doCommand(RESCALE_COMMAND, INTEGERS[scale]);
                        TSimMachinePane.this.placeholderPanel.setVisible(false);
                        TSimMachinePane.this.placeholderLabel.setVisible(false);
                        TSimMachinePane.this.bluePanel.setVisible(true);
                        TSimMachinePane.this.repaint();
                        this.isRunning = false;
                        this.thread = null;
                        return;
                    }
                }
                TImageManager.prepare((byte)0, scale);
            }
        }
    }

    protected class Listener
    implements ActionListener,
    ChangeListener,
    PropertyChangeListener {
        protected Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JToggleButton button;
            button.setPressedIcon((button = (JToggleButton)e.getSource()).getModel().isSelected() ? TSimMachinePane.this.switchOffIcon : TSimMachinePane.this.switchOnIcon);
            TSimMachinePane.this.fireStateChanged();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            TSimMachinePane.this.doCommand(UPDATE_COMMAND, null);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("enabled".equals(e.getPropertyName())) {
                Object source = e.getSource();
                if (source == TSimMachinePane.this.loadAction) {
                    TSimMachinePane.this.loadButton.setEnabled(TSimMachinePane.this.loadAction.isEnabled());
                } else if (source == TSimMachinePane.this.lookAction) {
                    TSimMachinePane.this.lookButton.setEnabled(TSimMachinePane.this.lookAction.isEnabled());
                } else if (source == TSimMachinePane.this.stepAction) {
                    TSimMachinePane.this.stepButton.setEnabled(TSimMachinePane.this.stepAction.isEnabled());
                } else if (source == TSimMachinePane.this.runAction) {
                    TSimMachinePane.this.runButton.setEnabled(TSimMachinePane.this.runAction.isEnabled());
                } else if (source == TSimMachinePane.this.enterAction) {
                    TSimMachinePane.this.enterButton.setEnabled(TSimMachinePane.this.enterAction.isEnabled());
                } else if (source == TSimMachinePane.this.interruptAction) {
                    TSimMachinePane.this.interruptButton.setEnabled(TSimMachinePane.this.interruptAction.isEnabled());
                } else if (source == TSimMachinePane.this.resetAction) {
                    TSimMachinePane.this.resetButton.setEnabled(TSimMachinePane.this.resetAction.isEnabled());
                }
            }
        }
    }
}

